package jcircus.exceptions;

import jcircus.util.ChanUse;

/**
 * ChanUseUnificationException.java
 *
 * @author Angela Freitas
 */
public class ChanUseUnificationException extends Exception {
    
    public ChanUseUnificationException() {
        super("It is not possible to unify the ChanUse in the composite processes.");
    }
    
    public ChanUseUnificationException(String chanName, ChanUse chanUseInEnv, ChanUse chanUse) {
        super("Channel '" + chanName + "': " + chanUseInEnv + " (old), " + chanUse + "(new)");
    }

}
